Attribute VB_Name = "mdRemoveConstraints"
'	This is a part of the source code for Pro/DESKTOP.
'	Copyright (C) 1999 Parametric Technology Corporation.
'	All rights reserved.


Rem Convenience Function to remove all the constraints associated with a set of lines

Sub RemoveConstraints(lineSet As ObjectSet, nature As Double)

Rem To get the global objects like application, part, workplane, sketch
GetApplicationObject

Dim Part As PartDocument
Set Part = app.GetActiveDoc

Dim wp As aWorkplane
Set wp = Part.GetActiveWorkplane

Dim inside As ObjectSet
Dim outside As ObjectSet
Dim neither As ObjectSet

Set inside = app.GetClass("ObjectSet").CreateAObjectSet
Set outside = app.GetClass("ObjectSet").CreateAObjectSet
Set neither = app.GetClass("ObjectSet").CreateAObjectSet

wp.SeparateConstraints lineSet, inside, outside, neither

Dim m_inside As ObjectSet
Dim m_neither As ObjectSet

If Not (inside Is Nothing) Then
    Set m_inside = RemoveImplicit(inside)
End If
    If Not (neither Is Nothing) Then
    Set m_neither = RemoveImplicit(neither)
End If

Dim constrainset As ObjectSet

If nature = 0 Then
    If m_neither Is Nothing Then GoTo 10
    Set constrainset = m_neither
Else
If nature = 1 Then
        If m_inside Is Nothing Then GoTo 10
        Set constrainset = m_inside
Else
If nature = 2 Then
    Dim totalset As ObjectSet
    Set totalset = app.GetClass("ObjectSet").CreateAObjectSet
    
    If (Not (m_inside Is Nothing)) Then
    Set totalset = m_inside
    End If
    
    If (Not (m_neither Is Nothing)) Then
        Call AddSet(totalset, m_neither)
        'totalset.AddSet m_neither
    End If
    
    If (totalset.GetAnyMember Is Nothing) Then GoTo 10
    
    Set constrainset = totalset
Else
    'MsgBox "The parameter nature has to be 0 , 1 or 2 )"
    GoTo 10
End If
End If
End If

count = constrainset.GetCount

Dim con As aConstraint
Dim it As Iterator
Set it = app.GetClass("It").CreateAObjectIt(constrainset)
Set con = it.start()

Do While it.IsActive
    con.Delete
Set con = it.Next()
Loop

    
    constrainset.RemoveAll

10:
End Sub


Function RemoveImplicit(constrainset As ObjectSet)

GetApplicationObject

Dim result As ObjectSet
Set result = app.GetClass("ObjectSet").CreateAObjectSet

Dim con As aConstraint

count = constrainset.GetCount

Dim it As Iterator
Set it = app.GetClass("It").CreateAObjectIt(constrainset)
Set con = it.start()

Do While it.IsActive

    If (con.IsImplicit = False) Then
        result.AddMember con
    End If
    
Set con = it.Next()
Loop

Set RemoveImplicit = result

End Function

Sub AddSet(destinationSet, sourceSet)

Dim it As Iterator
Set it = app.GetClass("It").CreateAObjectIt(sourceSet)
On Error Resume Next
destinationSet.AddMember it.start
Do While it.IsActive
    destinationSet.AddMember it.Current
    it.Next
Loop
End Sub


